
type ImagePreviewProps = {
    previewUrl?: string | null;
    fallbackUrl?: string | null;
    alt?: string;
};

export const ImagePreview = ({ previewUrl, fallbackUrl, alt = "Vista previa" }: ImagePreviewProps) => {
    const urlToShow = previewUrl || fallbackUrl;

    if (!urlToShow) return null;

    return (
        <div className="mt-4">
            <p className="text-sm text-gray-500">
                {previewUrl ? "Vista previa:" : "Imagen actual:"}
            </p>
            <img
                src={urlToShow}
                alt={alt}
                className="mt-2 rounded-lg shadow-md w-48 h-auto object-cover"
            />
        </div>
    );
};