import { Input } from "@/Components/ui/input";
import { Label } from "@/Components/ui/label";
import { forwardRef } from "react";

export const FileInput = forwardRef<HTMLInputElement, React.ComponentProps<"input">>(({ id, ...props }, ref) => {
    return (
        <div className="grid w-full max-w-sm items-center gap-1.5">
            <Label htmlFor={id}>Seleccionar archivos</Label>
            <Input 
                id={id} 
                type="file" 
                ref={ref} 
                {...props} 
                className="cursor-pointer"
            />
        </div>
    );
});

FileInput.displayName = "FileInput";