<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cursos_materiales_redes', function (Blueprint $table) {
            $table->id();
            $table->string('key', 50);
            $table->foreignId('id_curso_material')->nullable()->constrained('cursos_materiales')->onDelete('set null');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cursos_materiales_redes');
    }
};
