<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('grados_estudiantes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_estudiante')->nullable()->constrained('estudiantes')->onDelete('set null');
            $table->foreignId('id_grado')->nullable()->constrained('grados')->onDelete('set null');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('grados_estudiantes');
    }
};
