<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('conductas', function (Blueprint $table) {
            $table->id();
            $table->string('conducta', 20);
            $table->string('observacion')->nullable();
            $table->date('fecha');
            $table->foreignId('id_estudiante')->constrained('estudiantes');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('conductas');
    }
};
