<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Modelo Nota
 * 
 * Representa una nota dentro del sistema.
 *
 * @package App\Models
 */
class Nota extends Model
{
    use HasFactory;

    /**
     * Nombre de la tabla en la base de datos.
     * 
     * @var string
     */
    protected $table = 'notas';

    /**
     * Atributos que se pueden asignar masivamente.
     * 
     * @var array<int, string>
     */
    protected $fillable = [
        "r_p_cantidad_c1",
        "r_p_cantidad_c2",
        "r_p_cantidad_c3",
        "r_p_cantidad_c4",
        "r_p_r_e_cambio_c1",
        "r_p_r_e_cambio_c2",
        "r_p_r_e_cambio_c3",
        "r_p_r_e_cambio_c4",
        "r_p_f_m_localizacion_c1",
        "r_p_f_m_localizacion_c2",
        "r_p_f_m_localizacion_c3",
        "r_p_f_m_localizacion_c4",
        "r_p_g_d_incertidumbre_c1",
        "r_p_g_d_incertidumbre_c2",
        "r_p_g_d_incertidumbre_c3",
        "r_p_g_d_incertidumbre_c4",
        'fecha',
        'url_imagen',
        'id_estudiante',
    ];

    /**
     * Relación con el modelo Estudiante.
     * 
     * Un registro pertenece a un solo estudiante.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function estudiante()
    {
        return $this->belongsTo(Estudiante::class, 'id_estudiante');
    }
}
