<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Modelo GradoEstudiante
 * 
 * Representa la relación entre estudiantes y grados.
 *
 * @package App\Models
 */
class GradoEstudiante extends Model
{
    use HasFactory;

    /**
     * Nombre de la tabla en la base de datos.
     * 
     * @var string
     */
    protected $table = 'grados_estudiantes';

    /**
     * Atributos que se pueden asignar masivamente.
     * 
     * @var array<int, string>
     */
    protected $fillable = [
        'id_estudiante',
        'id_grado',
    ];

    /**
     * Relación con el modelo Estudiante.
     * 
     * Un registro pertenece a un solo estudiante.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function estudiante()
    {
        return $this->belongsTo(Estudiante::class, 'id_estudiante');
    }

    /**
     * Relación con el modelo Grado.
     * 
     * Un registro pertenece a un solo grado.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function grado()
    {
        return $this->belongsTo(Grado::class, 'id_grado');
    }
}
