<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Modelo CursoMaterialVideo
 * 
 * Representa los materiales asociados a un curso, como PDFs, videos e imágenes.
 *
 * @package App\Models
 */
class CursoMaterialVideo extends Model
{
    use HasFactory;

    /**
     * Nombre de la tabla en la base de datos.
     * 
     * @var string
     */
    protected $table = 'cursos_materiales_videos';

    /**
     * Atributos que se pueden asignar masivamente.
     * 
     * @var array<int, string>
     */
    protected $fillable = [
        'id_curso_material',
        'url_video',
        'original_name',
        'size',
        'mime_type',
    ];

    /**
     * Relación con el modelo CursoMaterial.
     * 
     * Un material pertenece a un solo curso.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function curso_material()
    {
        return $this->belongsTo(CursoMaterial::class, 'id_curso_material');
    }
}
