<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Modelo CursoMaterial
 *
 * Representa un curso dentro del sistema.
 *
 * @package App\Models
 */
class CursoMaterial extends Model
{
    use HasFactory;

    /**
     * Nombre de la tabla en la base de datos.
     *
     * @var string
     */
    protected $table = 'cursos_materiales';

    /**
     * Atributos que se pueden asignar masivamente.
     *
     * @var array<int, string>
     */
    protected $fillable = ['nombre', 'id_curso'];

    /**
     * Relación con la tabla `curso`.
     *
     * @return \Illuminate\Database\Eloquent\Relations\belongsTo
     */
    public function curso()
    {
        return $this->belongsTo(Curso::class, 'id_curso');
    }

    /**
     * Relación con la tabla intermedia `cursos_materiales_videos`.
     *
     * Un curso puede estar inscrito en varios videos.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function cursos_materiales_videos()
    {
        return $this->hasMany(CursoMaterialVideo::class, 'id_curso_material');
    }

    /**
     * Relación con la tabla intermedia `cursos_materiales_imagenes`.
     *
     * Un curso puede estar inscrito en varias imagenes.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function cursos_materiales_imagenes()
    {
        return $this->hasMany(CursoMaterialImagen::class, 'id_curso_material');
    }

    /**
     * Relación con la tabla intermedia `cursos_materiales_pdfs`.
     *
     * Un curso puede estar inscrito en varios pdfs.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function cursos_materiales_pdfs()
    {
        return $this->hasMany(CursoMaterialPdf::class, 'id_curso_material');
    }
    
    /**
     * Relación con la tabla intermedia `cursos_materiales_redes`.
     *
     * Un curso puede estar inscrito en varios pdfs.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function cursos_materiales_redes()
    {
        return $this->hasMany(CursoMaterialRed::class, 'id_curso_material');
    }
}
