<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Modelo CursoEstudiante
 * 
 * Representa la relación entre estudiantes y cursos.
 *
 * @package App\Models
 */
class CursoEstudiante extends Model
{
    use HasFactory;

    /**
     * Nombre de la tabla en la base de datos.
     * 
     * @var string
     */
    protected $table = 'cursos_estudiantes';

    /**
     * Atributos que se pueden asignar masivamente.
     * 
     * @var array<int, string>
     */
    protected $fillable = [
        'id_estudiante',
        'id_curso',
    ];

    /**
     * Relación con el modelo Estudiante.
     * 
     * Un registro pertenece a un solo estudiante.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function estudiante()
    {
        return $this->belongsTo(Estudiante::class, 'id_estudiante');
    }

    /**
     * Relación con el modelo Curso.
     * 
     * Un registro pertenece a un solo curso.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function curso()
    {
        return $this->belongsTo(Curso::class, 'id_curso');
    }
}
