<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Modelo Conducta
 * 
 * Representa una conducta dentro del sistema.
 *
 * @package App\Models
 */
class Conducta extends Model
{
    use HasFactory;

    /**
     * Nombre de la tabla en la base de datos.
     * 
     * @var string
     */
    protected $table = 'conductas';

    /**
     * Atributos que se pueden asignar masivamente.
     * 
     * @var array<int, string>
     */
    protected $fillable = [
        'conducta',
        'observacion',
        'fecha',
        'id_estudiante',
    ];

    /**
     * Relación con el modelo Estudiante.
     * 
     * Un registro pertenece a un solo estudiante.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function estudiante()
    {
        return $this->belongsTo(Estudiante::class, 'id_estudiante');
    }
}
