<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class NotaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "r_p_cantidad_c1" => 'nullable|string|min:1|max:3',
            "r_p_cantidad_c2" => 'nullable|string|min:1|max:3',
            "r_p_cantidad_c3" => 'nullable|string|min:1|max:3',
            "r_p_cantidad_c4" => 'nullable|string|min:1|max:3',
            "r_p_r_e_cambio_c1" => 'nullable|string|min:1|max:3',
            "r_p_r_e_cambio_c2" => 'nullable|string|min:1|max:3',
            "r_p_r_e_cambio_c3" => 'nullable|string|min:1|max:3',
            "r_p_r_e_cambio_c4" => 'nullable|string|min:1|max:3',
            "r_p_f_m_localizacion_c1" => 'nullable|string|min:1|max:3',
            "r_p_f_m_localizacion_c2" => 'nullable|string|min:1|max:3',
            "r_p_f_m_localizacion_c3" => 'nullable|string|min:1|max:3',
            "r_p_f_m_localizacion_c4" => 'nullable|string|min:1|max:3',
            "r_p_g_d_incertidumbre_c1" => 'nullable|string|min:1|max:3',
            "r_p_g_d_incertidumbre_c2" => 'nullable|string|min:1|max:3',
            "r_p_g_d_incertidumbre_c3" => 'nullable|string|min:1|max:3',
            "r_p_g_d_incertidumbre_c4" => 'nullable|string|min:1|max:3',
            'fecha' => 'required|date|before_or_equal:today',
            'url_imagen' => 'nullable|string',
            'id_estudiante' => 'required|exists:estudiantes,id',
        ];
    }
    /**
     * Obtiene los mensajes de error personalizados para cada regla.
     *
     * @return array<string, string>
     */
    public function messages()
    {
        return [
           
            'r_p_cantidad_c1.string' => 'Resuelve problemas de cantidad de C1 debe ser una cadena.',
            'r_p_cantidad_c1.min' => 'Resuelve problemas de cantidad de C1 debe tener al menos 1 carácter.',
            'r_p_cantidad_c1.max' => 'Resuelve problemas de cantidad de C1 no puede tener más de 3 caracteres.',
    
            'r_p_cantidad_c2.string' => 'Resuelve problemas de cantidad de C2 debe ser una cadena.',
            'r_p_cantidad_c2.min' => 'Resuelve problemas de cantidad de C2 debe tener al menos 1 carácter.',
            'r_p_cantidad_c2.max' => 'Resuelve problemas de cantidad de C2 no puede tener más de 3 caracteres.',
    
            'r_p_cantidad_c3.string' => 'Resuelve problemas de cantidad de C3 debe ser una cadena.',
            'r_p_cantidad_c3.min' => 'Resuelve problemas de cantidad de C3 debe tener al menos 1 carácter.',
            'r_p_cantidad_c3.max' => 'Resuelve problemas de cantidad de C3 no puede tener más de 3 caracteres.',
    
           'r_p_cantidad_c4.string' => 'Resuelve problemas de cantidad de C4 debe ser una cadena.',
            'r_p_cantidad_c4.min' => 'Resuelve problemas de cantidad de C4 debe tener al menos 1 carácter.',
            'r_p_cantidad_c4.max' => 'Resuelve problemas de cantidad de C4 no puede tener más de 3 caracteres.',
    
            'r_p_r_e_cambio_c1.string' => 'Resuelve problemas de regularidad, equivalencia y cambio de C1 debe ser una cadena.',
            'r_p_r_e_cambio_c1.min' => 'Resuelve problemas de regularidad, equivalencia y cambio de C1 debe tener al menos 1 carácter.',
            'r_p_r_e_cambio_c1.max' => 'Resuelve problemas de regularidad, equivalencia y cambio de C1 no puede tener más de 3 caracteres.',
    
            'r_p_r_e_cambio_c2.string' => 'Resuelve problemas de regularidad, equivalencia y cambio de C2 debe ser una cadena.',
            'r_p_r_e_cambio_c2.min' => 'Resuelve problemas de regularidad, equivalencia y cambio de C2 debe tener al menos 1 carácter.',
            'r_p_r_e_cambio_c2.max' => 'Resuelve problemas de regularidad, equivalencia y cambio de C2 no puede tener más de 3 caracteres.',
    
            'r_p_r_e_cambio_c3.string' => 'Resuelve problemas de regularidad, equivalencia y cambio de C3 debe ser una cadena.',
            'r_p_r_e_cambio_c3.min' => 'Resuelve problemas de regularidad, equivalencia y cambio de C3 debe tener al menos 1 carácter.',
            'r_p_r_e_cambio_c3.max' => 'Resuelve problemas de regularidad, equivalencia y cambio de C3 no puede tener más de 3 caracteres.',
    
            'r_p_r_e_cambio_c4.string' => 'Resuelve problemas de regularidad, equivalencia y cambio de C4 debe ser una cadena.',
            'r_p_r_e_cambio_c4.min' => 'Resuelve problemas de regularidad, equivalencia y cambio de C4 debe tener al menos 1 carácter.',
            'r_p_r_e_cambio_c4.max' => 'Resuelve problemas de regularidad, equivalencia y cambio de C4 no puede tener más de 3 caracteres.',
    
            'r_p_f_m_localizacion_c1.string' => 'Resuelve problemas de forma, movimiento y localización de C1 debe ser una cadena.',
            'r_p_f_m_localizacion_c1.min' => 'Resuelve problemas de forma, movimiento y localización de C1 debe tener al menos 1 carácter.',
            'r_p_f_m_localizacion_c1.max' => 'Resuelve problemas de forma, movimiento y localización de C1 no puede tener más de 3 caracteres.',
    
            'r_p_f_m_localizacion_c2.string' => 'Resuelve problemas de forma, movimiento y localización de C2 debe ser una cadena.',
            'r_p_f_m_localizacion_c2.min' => 'Resuelve problemas de forma, movimiento y localización de C2 debe tener al menos 1 carácter.',
            'r_p_f_m_localizacion_c2.max' => 'Resuelve problemas de forma, movimiento y localización de C2 no puede tener más de 3 caracteres.',
    
            'r_p_f_m_localizacion_c3.string' => 'Resuelve problemas de forma, movimiento y localización de C3 debe ser una cadena.',
            'r_p_f_m_localizacion_c3.min' => 'Resuelve problemas de forma, movimiento y localización de C3 debe tener al menos 1 carácter.',
            'r_p_f_m_localizacion_c3.max' => 'Resuelve problemas de forma, movimiento y localización de C3 no puede tener más de 3 caracteres.',
    
            'r_p_f_m_localizacion_c4.string' => 'Resuelve problemas de forma, movimiento y localización de C4 debe ser una cadena.',
            'r_p_f_m_localizacion_c4.min' => 'Resuelve problemas de forma, movimiento y localización de C4 debe tener al menos 1 carácter.',
            'r_p_f_m_localizacion_c4.max' => 'Resuelve problemas de forma, movimiento y localización de C4 no puede tener más de 3 caracteres.',
    
            'r_p_g_d_incertidumbre_c1.string' => 'Resuelve problemas de gestión de datos e incertidumbre de C1 debe ser una cadena.',
            'r_p_g_d_incertidumbre_c1.min' => 'Resuelve problemas de gestión de datos e incertidumbre de C1 debe tener al menos 1 carácter.',
            'r_p_g_d_incertidumbre_c1.max' => 'Resuelve problemas de gestión de datos e incertidumbre de C1 no puede tener más de 3 caracteres.',

            'r_p_g_d_incertidumbre_c2.string' => 'Resuelve problemas de gestión de datos e incertidumbre de C2 debe ser una cadena.',
            'r_p_g_d_incertidumbre_c2.min' => 'Resuelve problemas de gestión de datos e incertidumbre de C2 debe tener al menos 1 carácter.',
            'r_p_g_d_incertidumbre_c2.max' => 'Resuelve problemas de gestión de datos e incertidumbre de C2 no puede tener más de 3 caracteres.',

            'r_p_g_d_incertidumbre_c3.string' => 'Resuelve problemas de gestión de datos e incertidumbre de C3 debe ser una cadena.',
            'r_p_g_d_incertidumbre_c3.min' => 'Resuelve problemas de gestión de datos e incertidumbre de C3 debe tener al menos 1 carácter.',
            'r_p_g_d_incertidumbre_c3.max' => 'Resuelve problemas de gestión de datos e incertidumbre de C3 no puede tener más de 3 caracteres.',

            'r_p_g_d_incertidumbre_c4.string' => 'Resuelve problemas de gestión de datos e incertidumbre de C4 debe ser una cadena.',
            'r_p_g_d_incertidumbre_c4.min' => 'Resuelve problemas de gestión de datos e incertidumbre de C4 debe tener al menos 1 carácter.',
            'r_p_g_d_incertidumbre_c4.max' => 'Resuelve problemas de gestión de datos e incertidumbre de C4 no puede tener más de 3 caracteres.',

            'fecha.required' => 'La fecha es obligatoria.',
            'fecha.date' => 'La fecha debe ser válida.',
            'fecha.before_or_equal' => 'La fecha no puede ser futura.',
    
            'url_imagen.string' => 'La URL de la imagen debe ser válida.',
    
            'id_estudiante.required' => 'El estudiante es obligatorio.',
            'id_estudiante.exists' => 'El estudiante seleccionado no existe.',
        ];
    }
    
}
