<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class GradoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules()
    {
        return [
            'nombre' => 'required|string|max:10|unique:grados,nombre,' . optional($this->route('grado'))->id . ',id',
        ];
    }

    /**
     * Obtiene los mensajes de error personalizados para cada regla.
     *
     * @return array<string, string>
     */
    public function messages()
    {
        return [
            'nombre.required' => 'El nombre del grado es obligatorio.',
            'nombre.string' => 'El nombre del grado debe ser una cadena de texto.',
            'nombre.max' => 'El nombre del grado no debe exceder los 10 caracteres.',
            'nombre.unique' => 'El nombre del grado ya está registrado.',
        ];
    }
}
