<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class GradoEstudianteRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules()
    {
        return [
            'id_estudiante' => 'required|exists:estudiantes,id',
            'id_grado' => 'required|exists:grados,id',
        ];
    }

    /**
     * Obtiene los mensajes de error personalizados para cada regla.
     *
     * @return array<string, string>
     */
    public function messages()
    {
        return [
            'id_estudiante.required' => 'El estudiante es obligatorio.',
            'id_estudiante.exists' => 'El estudiante seleccionado no existe.',

            'id_grado.required' => 'El grado es obligatorio.',
            'id_grado.exists' => 'El grado seleccionado no existe.',
        ];
    }
}
