<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class EstudianteRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules()
    {
        return [
            'dni' => 'required|string|size:8|unique:estudiantes,dni,' . optional($this->route('estudiante'))->id . ',id',
            'nombres' => 'required|string|max:100',
            'apellido_paterno' => 'required|string|max:50',
            'apellido_materno' => 'required|string|max:50',
            'celular' => 'nullable|string|size:9|regex:/^[0-9]+$/',
            'celular_apoderado' => 'nullable|string|size:9|regex:/^[0-9]+$/',
            'password' => 'nullable|string|min:8',
            'cursos' => 'required|array|min:1',
            'cursos.*.id' => 'required|integer|exists:cursos,id',
            'grado' => 'required|array|min:1',
            'grado.*.id' => 'required|integer|exists:grados,id',
        ];
    }   

    /**
     * Obtiene los mensajes de error personalizados para cada regla.
     *
     * @return array<string, string>
     */
    public function messages()
    {
        return [
            'dni.required' => 'El DNI es obligatorio.',
            'dni.string' => 'El DNI debe ser una cadena de texto.',
            'dni.size' => 'El DNI debe tener exactamente 8 caracteres.',
            'dni.unique' => 'El DNI ya está registrado en el sistema.',
    
            'nombres.required' => 'El nombre es obligatorio.',
            'nombres.string' => 'El nombre debe ser una cadena de texto.',
            'nombres.max' => 'El nombre no debe exceder los 100 caracteres.',
    
            'apellido_paterno.required' => 'El apellido paterno es obligatorio.',
            'apellido_paterno.string' => 'El apellido paterno debe ser una cadena de texto.',
            'apellido_paterno.max' => 'El apellido paterno no debe exceder los 50 caracteres.',
    
            'apellido_materno.required' => 'El apellido materno es obligatorio.',
            'apellido_materno.string' => 'El apellido materno debe ser una cadena de texto.',
            'apellido_materno.max' => 'El apellido materno no debe exceder los 50 caracteres.',
    
            'celular.string' => 'El número de celular debe ser una cadena de texto.',
            'celular.size' => 'El número de celular debe tener exactamente 9 dígitos.',
            'celular.regex' => 'El número de celular solo debe contener números.',
    
            'celular_apoderado.string' => 'El número de celular del apoderado debe ser una cadena de texto.',
            'celular_apoderado.size' => 'El número de celular del apoderado debe tener exactamente 9 dígitos.',
            'celular_apoderado.regex' => 'El número de celular del apoderado solo debe contener números.',
    
            'password.string' => 'La contraseña debe ser una cadena de texto.',
            'password.min' => 'La contraseña debe tener al menos 8 caracteres.',
    
            'cursos.required' => 'Es obligatorio seleccionar al menos un curso.', 
            'cursos.array' => 'Los cursos deben ser un array.',
            'cursos.min' => 'Debe seleccionar al menos un curso.',
            
            'cursos.*.id.required' => 'El ID del curso es obligatorio.',
            'cursos.*.id.integer' => 'El ID del curso debe ser un número entero.',
            'cursos.*.id.exists' => 'El curso seleccionado no existe en la base de datos.',
        
            'grado.required' => 'El grado es obligatorio.',
            'grado.min' => 'Debe seleccionar al menos un grado.',

            'grado.*.id.required' => 'El ID del grado es obligatorio.',
            'grado.*.id.exists' => 'El grado seleccionado no existe en la base de datos.',
        ];
    }
}
