<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CursoMaterialRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules()
    {
        return [
            'nombre' => 'required|string|max:100',
            'id_curso' => 'required|exists:cursos,id',
            'pdfs' => 'nullable|array',
            'pdfs.*' => 'file|mimes:pdf|max:51200', // 50MB para PDFs
            'videos' => 'nullable|array',
            'videos.*' => 'file|mimetypes:video/mp4,video/avi,video/mpeg,video/quicktime,video/x-msvideo,video/x-matroska|max:512000', // 500MB para videos
            'redes' => 'nullable|array',
            'redes.*.key' => 'required|string|max:50',
            'imagenes' => 'nullable|array',
            'imagenes.*' => 'image|mimes:jpeg,png,jpg,gif,webp|max:51200', // 50MB para imágenes
        ];
    }

    /**
     * Obtiene los mensajes de error personalizados para cada regla.
     *
     * @return array<string, string>
     */
    public function messages()
    {
        return [
            'nombre.required' => 'El campo nombre de sesión es obligatorio.',
            'nombre.string' => 'La nombre de sesión debe ser una cadena de texto.',
            'nombre.max' => 'La nombre de sesión no debe superar los 100 caracteres.',

            'id_curso.required' => 'El curso es obligatorio.',
            'id_curso.exists' => 'El curso seleccionado no existe.',

            'redes.array' => 'El formato de redes sociales no es válido.',
            'redes.*.key.required' => 'El identificador de la red social es obligatorio.',
            'redes.*.key.string' => 'El identificador debe ser texto.',
            'redes.*.key.max' => 'El identificador no debe exceder 50 caracteres.',
          
            'pdfs.array' => 'Debe subir uno o más archivos PDF.',
            'pdfs.*.file' => 'Cada archivo PDF debe ser válido.',
            'pdfs.*.mimes' => 'Cada archivo debe ser un PDF.',
            'pdfs.*.max' => 'Cada PDF no debe superar los 50MB.',

            'videos.array' => 'Debe subir uno o más archivos de video.',
            'videos.*.file' => 'Cada video debe ser un archivo válido.',
            'videos.*.mimetypes' => 'Formatos permitidos: MP4, AVI, MPEG, QuickTime, MKV, etc.',
            'videos.*.max' => 'Cada video no debe superar los 500MB.',

            'imagenes.array' => 'Debe subir una o más imágenes.',
            'imagenes.*.image' => 'Cada archivo debe ser una imagen válida.',
            'imagenes.*.mimes' => 'Formatos permitidos: JPEG, PNG, JPG, GIF, WEBP.',
            'imagenes.*.max' => 'Cada imagen no debe superar los 50MB.',
        ];
    }

    // /**
    //  * Prepare the data for validation.
    //  */
    // protected function prepareForValidation()
    // {
    //     // Convertir tamaño máximo a bytes para la validación
    //     $this->merge([
    //         'max_upload_size' => 512000 * 1024, // 500MB en bytes
    //     ]);
    // }
}