<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CursoMaterialRedRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules()
    {
        return [
            'key' => 'required|string|max:50',
            'id_curso_material' => 'required|exists:cursos_materiales,id',
        ];
    }

    /**
     * Obtiene los mensajes de error personalizados para cada regla.
     *
     * @return array<string, string>
     */
    public function messages()
    {
        return [
            'key.required' => 'El key del video es obligatorio.',
            'key.string' => 'El key del video debe ser una cadena de texto.',
            'key.max' => 'El key del video no debe exceder los 50 caracteres.',
            
            'id_curso_material.required' => 'El curso es obligatorio.',
            'id_curso_material.exists' => 'El curso seleccionado no existe.',
           ];
    }
}
