<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ConductaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'conducta' => 'required|string|max:20',
            'observacion' => 'nullable|string',
            'fecha' => 'required|date|before_or_equal:today',
            'id_estudiante' => 'required|exists:estudiantes,id',
        ];
    }

    /**
     * Obtiene los mensajes de error personalizados para cada regla.
     *
     * @return array<string, string>
     */
    public function messages()
    {
        return [
            'conducta.required' => 'El campo conducta es obligatorio.',
            'conducta.string' => 'La conducta debe ser una cadena de texto.',
            'conducta.max' => 'La conducta no debe superar los 20 caracteres.',

            'observacion.string' => 'La observación debe ser una cadena de texto.',

            'fecha.required' => 'La fecha es obligatoria.',
            'fecha.date' => 'La fecha debe ser válida.',
            'fecha.before_or_equal' => 'La fecha no puede ser futura.',

            'id_estudiante.required' => 'El estudiante es obligatorio.',
            'id_estudiante.exists' => 'El estudiante seleccionado no existe.',
        ];
    }
}
