<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AsistenciaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'tipo' => 'required|string|in:presente,tardanza,falta',
            'fecha' => 'required|date|before_or_equal:today',
            'hora' => 'required|date_format:H:i',
            'id_estudiante' => 'required|exists:estudiantes,id',
        ];
    }

    /**
     * Obtiene los mensajes de error personalizados para cada regla.
     *
     * @return array<string, string>
     */
    public function messages()
    {
        return [
            'tipo.required' => 'El tipo de asistencia es obligatorio.',
            'tipo.string' => 'El tipo de asistencia debe ser una cadena de texto.',
            'tipo.in' => 'El tipo de asistencia debe ser "presente", "tardanza" o "falta".',

            'fecha.required' => 'La fecha de asistencia es obligatoria.',
            'fecha.date' => 'La fecha debe ser válida.',
            'fecha.before_or_equal' => 'La fecha no puede ser futura.',

            'hora.required' => 'La hora de asistencia es obligatoria.',
            'hora.date_format' => 'La hora debe estar en formato HH:MM.',

            'id_estudiante.required' => 'El estudiante es obligatorio.',
            'id_estudiante.exists' => 'El estudiante seleccionado no existe.',
        ];
    }
}
