<?php



namespace App\Http\Middleware;



use Closure;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\Auth;



class AuthenticateEstudiante

{

    /**

     * Redirige a la página de login si no está autenticado.

     *

     * @param \Illuminate\Http\Request $request

     * @return string|null

     */

    protected function redirectTo(Request $request): ?string

    {

        return $request->expectsJson() ? null : route('login.estudiante');

    }



    /**

     * Maneja la autenticación del estudiante.

     *

     * @param \Illuminate\Http\Request $request

     * @param \Closure $next

     * @param  string  ...$guards

     * @return mixed

     */

    public function handle(Request $request, Closure $next, ...$guards)

    {



        if (! Auth::guard('estudiante')->check()) {

            return redirect($this->redirectTo($request));

        }



        return $next($request);

    }

}

