<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class AuthMultipleGuards
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::guard('web')->check() || Auth::guard('estudiante')->check()) {
            return $next($request);
        }

        if ($request->expectsJson()) {
            return response()->json(['error' => 'No autorizado'], 403);
        }

        return Inertia::render('Auth/Login')->with(['error' => 'Debes iniciar sesión']);
    }
}
