<?php

namespace App\Http\Controllers;

use App\Models\Curso;
use App\Models\Estudiante;
use Inertia\Response;
use Inertia\Inertia;

class DashboardController extends Controller
{
    public function index():Response
    {
        $cantidad_estudiantes = Estudiante::count();
        $cantidad_cursos = Curso::count();

        return Inertia::render('Dashboard/Index', [
            'cantidad_estudiantes' => $cantidad_estudiantes,
            'cantidad_cursos' => $cantidad_cursos,
        ]);
    }
}
