<?php

namespace App\Http\Controllers;

use Inertia\Inertia;
use Inertia\Response;
use App\Http\Requests\CursoMaterialRequest;
use App\Models\CursoMaterial;
use App\Models\CursoMaterialImagen;
use App\Models\CursoMaterialPdf;
use App\Models\CursoMaterialVideo;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;

/**
 * Controlador CursoMaterialController
 *
 * Maneja la gestión de cursos_materiales usando Inertia.js.
 */
class CursoMaterialController extends Controller
{
    /**
     * Muestra la lista de cursos_materiales.
     *
     * @return Response
     */
    public function index()
    {
        $perPage = request('per_page', 10);
        $search = request('search', '');

        $cursos_materiales = CursoMaterial::latest()
            ->where('nombre', 'like', "%{$search}%")
            ->paginate($perPage)
            ->appends(['search' => $search, 'per_page' => $perPage]);

        return Inertia::render('CursosMateriales/Index', [
            'cursos_materiales' => $cursos_materiales,
            'filters' => request()->only(['search', 'per_page']),
            'status' => session()->only(['success', 'error']),
        ]);
    }

    /**
     * Almacena un nuevo curso_material en la base de datos.
     *
     * @param CursoMaterialRequest $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(CursoMaterialRequest $request)
    {
        $curso_material = CursoMaterial::create($request->validated());
        return redirect()->back()->with('success', 'Curso Material: ' . $curso_material->nombre . ' creado exitosamente.');
    }

    /**
     * Actualiza un curso_material existente en la base de datos.
     *
     * @param CursoMaterialRequest $request
     * @param CursoMaterial $curso_material
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(CursoMaterialRequest $request, CursoMaterial $curso_material)
    {
        $curso_material->update($request->validated());

        return redirect()->back()->with('success', 'Curso Material: ' . $curso_material->nombre . ' actualizado exitosamente.');
    }

    /**
     * Elimina un curso_material de la base de datos.
     *
     * @param CursoMaterial $curso_material
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy(CursoMaterial $curso_material)
    {
        $curso_material->delete();

        return redirect()->back()->with('success', 'Curso Material eliminado exitosamente.');
    }
}
