<?php

namespace App\Exports;

use App\Models\Estudiante;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\Exportable;

class EstudiantesExport implements FromView, ShouldAutoSize
{
    use Exportable;

    /**
     * @return \Illuminate\Support\Collection
     */
    public function view(): View
    {

        $estudiantes = Estudiante::with('cursos', 'grado', 'notas', 'asistencias', 'conductas')->get();

        return view('Exports.estudiantes-excel', [
            'estudiantes' => $estudiantes,
        ]);
    }
}
