<?php

use App\Http\Controllers\Academico\CicloController;
use App\Http\Controllers\Academico\CursoController;
use App\Http\Controllers\Academico\HorarioController;
use App\Http\Controllers\Persona\CredencialController;
use App\Http\Controllers\Auth\UserController;
use App\Http\Controllers\Educacion\AreaController;
use App\Http\Controllers\Educacion\CarreraController;
use App\Http\Controllers\Educacion\ColegioController;
use App\Http\Controllers\Educacion\UniversidadController;
use App\Http\Controllers\Evaluacion\AsistenciaController;
use App\Http\Controllers\Evaluacion\ConductaController;
use App\Http\Controllers\Evaluacion\EncuestaController;
use App\Http\Controllers\Evaluacion\NotaController;
use App\Http\Controllers\Evaluacion\PreguntaController;
use App\Http\Controllers\Evaluacion\PromedioController;
use App\Http\Controllers\ExportExcelsController;
use App\Http\Controllers\ExportPdfsController;
use App\Http\Controllers\Finanza\BecaController;
use App\Http\Controllers\Finanza\PagoController;
use App\Http\Controllers\Finanza\SyncPagoController;
use App\Http\Controllers\ImagenController;
use App\Http\Controllers\InformacionEstudianteController;
use App\Http\Controllers\IngresantesController;
use App\Http\Controllers\Persona\ApoderadoController;
use App\Http\Controllers\Persona\DocenteController;
use App\Http\Controllers\Persona\EstudianteController;
use App\Http\Controllers\Persona\PersonaController;
use App\Http\Controllers\PivoteAreaCursoDocenteController;
use App\Http\Controllers\PivoteEncuestaDocenteController;
use App\Http\Controllers\PivoteEncuestaEstudianteController;
use App\Http\Controllers\PivoteHorarioCarreraEstudianteController;
use App\Http\Controllers\PivoteHorarioController;
use App\Http\Controllers\PivotePreguntaDocenteController;
use App\Http\Controllers\ResultadoEncuestaController;
use App\Http\Controllers\VideoController;
use App\Http\Controllers\WhatsappController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

Route::group(
    [
        'middleware' => 'jwt.verify',
    ],
    function () {
        Route::prefix('personas')->group(function () {
            Route::get('/', [PersonaController::class, 'getAll'])->name('personas.getAll');
            Route::get('/{id}', [PersonaController::class, 'show'])->name('personas.show');
            Route::post('/', [PersonaController::class, 'save'])->name('personas.save');
            Route::put('/{id}', [PersonaController::class, 'update'])->name('personas.update');
            Route::delete('/{id}', [PersonaController::class, 'delete'])->name('personas.destroy');
        });
        Route::prefix('usuarios')->group(function () {
            Route::get('/', [UserController::class, 'getAll'])->name('usuarios.getAll');
            Route::get('/{id}', [UserController::class, 'show'])->name('usuarios.show');
            Route::post('/', [UserController::class, 'save'])->name('usuarios.save');
            Route::put('/{id}', [UserController::class, 'update'])->name('usuarios.update');
            Route::delete('/{id}', [UserController::class, 'delete'])->name('usuarios.destroy');
        });
        Route::prefix('credenciales')->group(function () {
            Route::get('/', [CredencialController::class, 'getAll'])->name('credenciales.getAll');
            Route::get('/{id}', [CredencialController::class, 'show'])->name('credenciales.show');
            Route::post('/', [CredencialController::class, 'save'])->name('credenciales.save');
            Route::put('/{id}', [CredencialController::class, 'update'])->name('credenciales.update');
            Route::delete('/{id}', [CredencialController::class, 'delete'])->name('credenciales.destroy');
        });
        Route::prefix('estudiantes')->group(function () {
            Route::get('/{id}', [EstudianteController::class, 'show'])->name('estudiantes.show');
            Route::post('/', [EstudianteController::class, 'save'])->name('estudiantes.save');
            Route::put('/{id}', [EstudianteController::class, 'update'])->name('estudiantes.update');
            Route::delete('/{id}', [EstudianteController::class, 'delete'])->name('estudiantes.destroy');
        });
        Route::prefix('apoderados')->group(function () {
            Route::get('/', [ApoderadoController::class, 'getAll'])->name('apoderados.getAll');
            Route::get('/{id}', [ApoderadoController::class, 'show'])->name('apoderados.show');
            Route::post('/', [ApoderadoController::class, 'save'])->name('apoderados.save');
            Route::put('/{id}', [ApoderadoController::class, 'update'])->name('apoderados.update');
            Route::delete('/{id}', [ApoderadoController::class, 'delete'])->name('apoderados.destroy');
        });
        Route::prefix('colegios')->group(function () {
            Route::get('/', [ColegioController::class, 'getAll'])->name('colegios.getAll');
            Route::get('/{id}', [ColegioController::class, 'show'])->name('colegios.show');
            Route::post('/', [ColegioController::class, 'save'])->name('colegios.save');
            Route::put('/{id}', [ColegioController::class, 'update'])->name('colegios.update');
            Route::delete('/{id}', [ColegioController::class, 'delete'])->name('colegios.destroy');
        });
        Route::prefix('carreras')->group(function () {
            Route::get('/', [CarreraController::class, 'getAll'])->name('carreras.getAll');
            Route::get('/{id}', [CarreraController::class, 'show'])->name('carreras.show');
            Route::post('/', [CarreraController::class, 'save'])->name('carreras.save');
            Route::put('/{id}', [CarreraController::class, 'update'])->name('carreras.update');
            Route::delete('/{id}', [CarreraController::class, 'delete'])->name('carreras.destroy');
        });
        Route::prefix('promedios')->group(function () {
            Route::get('/', [PromedioController::class, 'getAll'])->name('promedios.getAll');
            Route::get('/{id}', [PromedioController::class, 'show'])->name('promedios.show');
            Route::post('/', [PromedioController::class, 'save'])->name('promedios.save');
            Route::put('/{id}', [PromedioController::class, 'update'])->name('promedios.update');
            Route::delete('/{id}', [PromedioController::class, 'delete'])->name('promedios.destroy');
        });
        Route::prefix('asistencias')->group(function () {
            Route::get('/', [AsistenciaController::class, 'getAll'])->name('asistencias.getAll');
            Route::get('/{id}', [AsistenciaController::class, 'show'])->name('asistencias.show');
            Route::post('/', [AsistenciaController::class, 'save'])->name('asistencias.save');
            Route::put('/{id}', [AsistenciaController::class, 'update'])->name('asistencias.update');
            Route::delete('/{id}', [AsistenciaController::class, 'delete'])->name('asistencias.destroy');
        });
        Route::prefix('conductas')->group(function () {
            Route::get('/', [ConductaController::class, 'getAll'])->name('conductas.getAll');
            Route::get('/{id}', [ConductaController::class, 'show'])->name('conductas.show');
            Route::post('/', [ConductaController::class, 'save'])->name('conductas.save');
            Route::put('/{id}', [ConductaController::class, 'update'])->name('conductas.update');
            Route::delete('/{id}', [ConductaController::class, 'delete'])->name('conductas.destroy');
        });
        Route::prefix('notas')->group(function () {
            Route::get('/', [NotaController::class, 'getAll'])->name('notas.getAll');
            Route::get('/{id}', [NotaController::class, 'show'])->name('notas.show');
            Route::post('/', [NotaController::class, 'save'])->name('notas.save');
            Route::put('/{id}', [NotaController::class, 'update'])->name('notas.update');
            Route::delete('/{id}', [NotaController::class, 'delete'])->name('notas.destroy');
        });
        Route::prefix('horarios')->group(function () {
            Route::get('/{id}', [HorarioController::class, 'show'])->name('horarios.show');
            Route::post('/', [HorarioController::class, 'save'])->name('horarios.save');
            Route::put('/{id}', [HorarioController::class, 'update'])->name('horarios.update');
            Route::delete('/{id}', [HorarioController::class, 'delete'])->name('horarios.destroy');
        });
        Route::prefix('ciclos')->group(function () {
            Route::get('/', [CicloController::class, 'getAll'])->name('ciclos.getAll');
            Route::get('/{id}', [CicloController::class, 'show'])->name('ciclos.show');
            Route::post('/', [CicloController::class, 'save'])->name('ciclos.save');
            Route::put('/{id}', [CicloController::class, 'update'])->name('ciclos.update');
            Route::delete('/{id}', [CicloController::class, 'delete'])->name('ciclos.destroy');
        });
        Route::prefix('docentes')->group(function () {
            Route::get('/{id}', [DocenteController::class, 'show'])->name('docentes.show');
            Route::post('/', [DocenteController::class, 'save'])->name('docentes.save');
            Route::put('/{id}', [DocenteController::class, 'update'])->name('docentes.update');
            Route::delete('/{id}', [DocenteController::class, 'delete'])->name('docentes.destroy');
        });
        Route::prefix('areas')->group(function () {
            Route::get('/', [AreaController::class, 'getAll'])->name('areas.getAll');
            Route::get('/{id}', [AreaController::class, 'show'])->name('areas.show');
            Route::post('/', [AreaController::class, 'save'])->name('areas.save');
            Route::put('/{id}', [AreaController::class, 'update'])->name('areas.update');
            Route::delete('/{id}', [AreaController::class, 'delete'])->name('areas.destroy');
        });
        Route::prefix('encuestas')->group(function () {
            Route::get('/', [EncuestaController::class, 'getAll'])->name('encuestas.getAll');
            Route::get('/{id}', [EncuestaController::class, 'show'])->name('encuestas.show');
            Route::post('/', [EncuestaController::class, 'save'])->name('encuestas.save');
            Route::put('/{id}', [EncuestaController::class, 'update'])->name('encuestas.update');
            Route::delete('/{id}', [EncuestaController::class, 'delete'])->name('encuestas.destroy');
        });
        Route::prefix('preguntas')->group(function () {
            Route::get('/', [PreguntaController::class, 'getAll'])->name('preguntas.getAll');
            Route::get('/{id}', [PreguntaController::class, 'show'])->name('preguntas.show');
            Route::post('/', [PreguntaController::class, 'save'])->name('preguntas.save');
            Route::put('/{id}', [PreguntaController::class, 'update'])->name('preguntas.update');
            Route::delete('/{id}', [PreguntaController::class, 'delete'])->name('preguntas.destroy');
        });
        Route::prefix('cursos')->group(function () {
            Route::get('/', [CursoController::class, 'getAll'])->name('cursos.getAll');
            Route::get('/{id}', [CursoController::class, 'show'])->name('cursos.show');
            Route::post('/', [CursoController::class, 'save'])->name('cursos.save');
            Route::put('/{id}', [CursoController::class, 'update'])->name('cursos.update');
            Route::delete('/{id}', [CursoController::class, 'delete'])->name('cursos.destroy');
        });
        Route::prefix('pivote-cursos-carreras-docente')->group(function () {
            Route::get('/', [PivoteAreaCursoDocenteController::class, 'getAll'])->name('pivote-cursos-carreras-docente.getAll');
            Route::get('/{id}', [PivoteAreaCursoDocenteController::class, 'show'])->name('pivote-cursos-carreras-docente.show');
            Route::post('/', [PivoteAreaCursoDocenteController::class, 'save'])->name('pivote-cursos-carreras-docente.save');
            Route::put('/{id}', [PivoteAreaCursoDocenteController::class, 'update'])->name('pivote-cursos-carreras-docente.update');
            Route::delete('/{id}', [PivoteAreaCursoDocenteController::class, 'delete'])->name('pivote-cursos-carreras-docente.destroy');
        });
        Route::prefix('pivote-horarios-carreras-estudiantes')->group(function () {
            Route::get('/', [PivoteHorarioCarreraEstudianteController::class, 'getAll'])->name('pivote-horarios-carreras-estudiantes.getAll');
            Route::get('/{id}', [PivoteHorarioCarreraEstudianteController::class, 'show'])->name('pivote-horarios-carreras-estudiantes.show');
            Route::post('/', [PivoteHorarioCarreraEstudianteController::class, 'save'])->name('pivote-horarios-carreras-estudiantes.save');
            Route::put('/{id}', [PivoteHorarioCarreraEstudianteController::class, 'update'])->name('pivote-horarios-carreras-estudiantes.update');
            Route::delete('/{id}', [PivoteHorarioCarreraEstudianteController::class, 'delete'])->name('pivote-horarios-carreras-estudiantes.destroy');
        });
        Route::prefix('pagos')->group(function () {
            Route::get('/', [PagoController::class, 'getAll'])->name('pagos.getAll');
            Route::get('/{id}', [PagoController::class, 'show'])->name('pagos.show');
            Route::post('/', [PagoController::class, 'save'])->name('pagos.save');
            Route::put('/{id}', [PagoController::class, 'update'])->name('pagos.update');
            Route::delete('/{id}', [PagoController::class, 'delete'])->name('pagos.destroy');
        });
        Route::prefix('sincronizar-pagos')->group(function () {
            Route::get('/', [SyncPagoController::class, 'getAll'])->name('sincronizar-pagos.getAll');
            Route::post('/', [SyncPagoController::class, 'sync'])->name('sincronizar-pagos.sync');
        });

        Route::prefix('becas')->group(function () {
            Route::get('/', [BecaController::class, 'getAll'])->name('becas.getAll');
            Route::get('/{id}', [BecaController::class, 'show'])->name('becas.show');
            Route::post('/', [BecaController::class, 'save'])->name('becas.save');
            Route::put('/{id}', [BecaController::class, 'update'])->name('becas.update');
            Route::delete('/{id}', [BecaController::class, 'delete'])->name('becas.destroy');
        });
        Route::prefix('universidades')->group(function () {
            Route::get('/', [UniversidadController::class, 'getAll'])->name('universidades.getAll');
            Route::get('/{id}', [UniversidadController::class, 'show'])->name('universidades.show');
            Route::post('/', [UniversidadController::class, 'save'])->name('universidades.save');
            Route::put('/{id}', [UniversidadController::class, 'update'])->name('universidades.update');
            Route::delete('/{id}', [UniversidadController::class, 'delete'])->name('universidades.destroy');
        });
        Route::prefix('pivote-horarios')->group(function () {
            Route::get('/', [PivoteHorarioController::class, 'getAll'])->name('pivote-horarios.getAll');
            Route::get('/{id}', [PivoteHorarioController::class, 'show'])->name('pivote-horarios.show');
            Route::post('/', [PivoteHorarioController::class, 'save'])->name('pivote-horarios.save');
            Route::put('/{id}', [PivoteHorarioController::class, 'update'])->name('pivote-horarios.update');
            Route::delete('/{id}', [PivoteHorarioController::class, 'delete'])->name('pivote-horarios.destroy');
        });
        Route::prefix('pivote-preguntas-docentes')->group(function () {
            Route::get('/', [PivotePreguntaDocenteController::class, 'getAll'])->name('pivote-preguntas-docentes.getAll');
            Route::get('/{id}', [PivotePreguntaDocenteController::class, 'show'])->name('pivote-preguntas-docentes.show');
            Route::post('/', [PivotePreguntaDocenteController::class, 'save'])->name('pivote-preguntas-docentes.save');
            Route::put('/{id}', [PivotePreguntaDocenteController::class, 'update'])->name('pivote-preguntas-docentes.update');
            Route::delete('/{id}', [PivotePreguntaDocenteController::class, 'delete'])->name('pivote-preguntas-docentes.destroy');
        });
        Route::prefix('enviar-mensaje-whatsapp')->group(function () {
            Route::post('/welcome/estudiante/{celular}', [WhatsappController::class, 'sendMessageWelcomeEstudiante'])->name('enviar-mensaje-whatsapp.sendMessageWelcomeEstudiante');
            Route::post('/welcome/apoderado/{celular}', [WhatsappController::class, 'sendMessageWelcomeApoderado'])->name('enviar-mensaje-whatsapp.sendMessageWelcomeApoderado');
            Route::post('/estudiante/{celular}', [WhatsappController::class, 'sendMessageEstudianteCron'])->name('enviar-mensaje-whatsapp.sendMessageEstudianteCron');
            Route::post('/apoderado/{celular}', [WhatsappController::class, 'sendMessageApoderadoCron'])->name('enviar-mensaje-whatsapp.sendMessageApoderadoCron');
        });
        Route::prefix('videos')->group(function () {
            Route::get('/{id}', [VideoController::class, 'show'])->name('videos.show');
            Route::post('/', [VideoController::class, 'save'])->name('videos.save');
            Route::put('/{id}', [VideoController::class, 'update'])->name('videos.update');
            Route::delete('/{id}', [VideoController::class, 'delete'])->name('videos.destroy');
        });
        Route::prefix('imagenes')->group(function () {
            Route::get('/{id}', [ImagenController::class, 'show'])->name('imagenes.show');
            Route::post('/', [ImagenController::class, 'save'])->name('imagenes.save');
            Route::put('/{id}', [ImagenController::class, 'update'])->name('imagenes.update');
            Route::delete('/{id}', [ImagenController::class, 'delete'])->name('imagenes.destroy');
        });

        Route::get('/export-excel-all-estudiantes', [ExportExcelsController::class, 'exportExcelEstudiantesPdf'])->name('export.all.estudiantes.excel');
        Route::get('/export-excel-estudiante/{id}', [ExportExcelsController::class, 'exportExcelEstudiantePdf'])->name('export.estudiantes.excel');

        Route::post('informacion-estudiante', [InformacionEstudianteController::class, 'getInfoEstudiante']);
        
        Route::get('resultados-encuestas', [ResultadoEncuestaController::class, 'getAll']);
        
        // Route::prefix('pivote-encuesta-estudiantes')->group(function () {
        //     Route::get('/', [PivoteEncuestaEstudianteController::class, 'getAll'])->name('pivote-encuesta-estudiantes.getAll');
        //     Route::post('/', [PivoteEncuestaEstudianteController::class, 'save'])->name('pivote-encuesta-estudiantes.save');
        //     Route::get('/{id}', [PivoteEncuestaEstudianteController::class, 'show'])->name('pivote-encuesta-estudiantes.show');
        // });
        // Route::post('pivote-encuesta-estudiantes', [PivoteEncuestaEstudianteController::class, 'save']);
        
    },
);

Route::middleware('auth:credenciales')->post('pivote-encuesta-estudiantes', [PivoteEncuestaEstudianteController::class, 'save']);


Route::get('export-pdf-estudiante/{id}', [ExportPdfsController::class, 'exportCarnetEstudiantePdf']);

Route::prefix('horarios')->group(function () {
    Route::get('/', [HorarioController::class, 'getAll'])->name('horarios.getAll');
});
Route::prefix('estudiantes')->group(function () {
    Route::get('/', [EstudianteController::class, 'getAll'])->name('estudiantes.getAll');
});
Route::prefix('docentes')->group(function () {
    Route::get('/', [DocenteController::class, 'getAll'])->name('docentes.getAll');
});
Route::prefix('pivote-encuesta-docentes')->group(function () {
    Route::get('/', [PivoteEncuestaDocenteController::class, 'getAll'])->name('pivote-encuesta-docentes.getAll');
});

Route::prefix('videos')->group(function () {
    Route::get('/', [VideoController::class, 'getAll'])->name('videos.getAll');
});
Route::prefix('imagenes')->group(function () {
    Route::get('/', [ImagenController::class, 'getAll'])->name('imagenes.getAll');
});

Route::get('/facultades', [IngresantesController::class, 'fetchFacultades']);

Route::fallback(function () {
    return response()->json(
        [
            'success' => false,
            'message' => 'Not Found!',
        ],
        404,
    );
});

require __DIR__ . '/auth.php';
