<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Ferias</title>
</head>

<body>
    <table border="1">
        <thead>
            <tr>
                <th colspan="2" style="background-color: #144A99; color:white; text-align: center;">Estudiante</th>
                <th colspan="2" style="background-color: #144A99; color:white; text-align: center;">Apoderado</th>
                <th colspan="2" style="background-color: #144A99; color:white; text-align: center;">Pago</th>
            </tr>
            <tr>
                <th style="background-color: #144A99; color:white; text-align: center;">DNI</th>
                <th style="background-color: #144A99; color:white; text-align: center;">Datos</th>
                <th style="background-color: #144A99; color:white; text-align: center;">DNI</th>
                <th style="background-color: #144A99; color:white; text-align: center;">Datos</th>
                <th style="background-color: #144A99; color:white; text-align: center;">Recibo</th>
                <th style="background-color: #144A99; color:white; text-align: center;">Pago</th>
            </tr>
        </thead>
        <tbody>
            @php $tota_recaudado = 0; @endphp

            @foreach ($pivote_horarios_carreras_estudiantes as $pivote_estudiante)
                <tr>
                    <!-- Datos del estudiante -->
                    <td>
                        @if ($pivote_estudiante->estudiante && $pivote_estudiante->estudiante->persona)
                            {{ $pivote_estudiante->estudiante->persona->dni }}
                        @endif
                    </td>
                    <td>
                        @if ($pivote_estudiante->estudiante && $pivote_estudiante->estudiante->persona)
                            {{ $pivote_estudiante->estudiante->persona->nombres }} 
                            {{ $pivote_estudiante->estudiante->persona->apellido_paterno }}
                            {{ $pivote_estudiante->estudiante->persona->apellido_materno }}
                        @endif
                    </td>

                    <!-- Datos del apoderado -->
                    <td>
                        @if ($pivote_estudiante->estudiante && $pivote_estudiante->estudiante->apoderado && $pivote_estudiante->estudiante->apoderado->persona)
                            {{ $pivote_estudiante->estudiante->apoderado->persona->dni }}
                        @endif
                    </td>
                    <td>
                        @if ($pivote_estudiante->estudiante && $pivote_estudiante->estudiante->apoderado && $pivote_estudiante->estudiante->apoderado->persona)
                            {{ $pivote_estudiante->estudiante->apoderado->persona->nombres }} 
                            {{ $pivote_estudiante->estudiante->apoderado->persona->apellido_paterno }}
                            {{ $pivote_estudiante->estudiante->apoderado->persona->apellido_materno }}
                        @endif
                    </td>

                    <!-- Pagos -->
                    <td colspan="2">
                        @if (!empty($pivote_estudiante->pagos))
                            @foreach ($pivote_estudiante->pagos as $pago)
                                <p>
                                    {{ $pago->recibo }} : {{ number_format($pago->total, 2) }}
                                    @php $tota_recaudado += $pago->total; @endphp
                                </p>
                            @endforeach
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td colspan="5" style="text-align: right; font-weight: 600;">Total:</td>
                <td style="text-align: left; font-weight: 600;">{{ number_format($tota_recaudado, 2) }}</td>
            </tr>
        </tfoot>
    </table>
</body>

</html>
