<?php

namespace Database\Seeders;

use App\Models\Persona\Docente;
use App\Models\Persona\Persona;
use App\Models\PivoteAreaCursoDocente;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DocenteSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Persona::create([
            'id' => 1,
            'dni' => '70800936',
            'nombres' => 'JORDAN PAUL',
            'apellido_paterno' => 'TICONA',
            'apellido_materno' => 'SAENZ',
            'celular' => '',
            'domicilio' => '',
        ]);
        Docente::create([
            'id' => 1,
            'observacion' => '',
            'fotografia' => '',
            'id_persona' => 1,
            'estado' => 'VIGENTE',
            'descripcion' => 'Soy un docente con amplia experiencia en la enseñanza de matemáticas, apasionado por compartir conocimientos y motivar a mis estudiantes. Mi metodología es clara, dinámica e impecable, enfocada en reforzar la teoría y desarrollar habilidades prácticas para la resolución de problemas. Busco que cada alumno comprenda la materia de manera efectiva, dejando de lado el miedo a las matemáticas y adquiriendo confianza en sus capacidades.',
        ]);

        PivoteAreaCursoDocente::create([
            'id_area' => 1, 
            'id_curso' => 13, 
            'id_docente' => 1,
        ]);
        PivoteAreaCursoDocente::create([
            'id_area' => 2,
            'id_curso' => 13,
            'id_docente' => 1,
        ]);
        PivoteAreaCursoDocente::create([
            'id_area' => 3,
            'id_curso' => 13,
            'id_docente' => 1,
        ]);
        PivoteAreaCursoDocente::create([
            'id_area' => 4,
            'id_curso' => 13,
            'id_docente' => 1,
        ]);
        PivoteAreaCursoDocente::create([
            'id_area' => 5,
            'id_curso' => 13,
            'id_docente' => 1,
        ]);
    }
}
