<?php

namespace Database\Seeders;

use App\Models\Academico\Ciclo;
use App\Models\PivoteHorario;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CicloSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Ciclo::create([
            'id' => 1,
            'nombre' => 'PRIMERA SELECCIÓN - ABRIL, AGOSTO',
            'fecha_inicio' => "2025-04-01",
            'fecha_final' => "2025-08-01",
            'estado' => "VIGENTE",
        ]);
        Ciclo::create([
            'id' => 2,
            'nombre' => 'PRIMERA SELECCIÓN - AGOSTO, DICIEMBRE',
            'fecha_inicio' => "2025-08-01",
            'fecha_final' => "2025-12-01",
            'estado' => "VIGENTE",
        ]);
        PivoteHorario::create([
            'id' => 1,
            'id_horario' => 1,
            'id_ciclo' => 1,
        ]);
        PivoteHorario::create([
            'id' => 2,
            'id_horario' => 2,
            'id_ciclo' => 1,
        ]);
        PivoteHorario::create([
            'id' => 3,
            'id_horario' => 1,
            'id_ciclo' => 2,
        ]);
        PivoteHorario::create([
            'id' => 4,
            'id_horario' => 2,
            'id_ciclo' => 2,
        ]);
    }
}
