<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pivote_encuestas_estudiantes', function (Blueprint $table) {
            $table->id();
            $table->integer('respuesta');
            $table->foreignId('id_pivote_encuesta_docente')->constrained('pivote_encuestas_docentes');
            $table->foreignId('id_pivote_horario_carrera_estudiante')->constrained('pivote_horarios_carreras_estudiantes')->name('horarios_carreras_estudiantes');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pivote_encuestas_estudiantes');
    }
};
