<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pivote_horarios_carreras_estudiantes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_pivote_horario')->constrained('pivote_horarios');
            $table->foreignId('id_carrera')->constrained('carreras');
            $table->foreignId('id_estudiante')->constrained('estudiantes');
            $table->foreignId('id_universidad')->constrained('universidades')->nullable();
            $table->string('estado_pago', 15)->nullable();
            $table->string('estado_mensaje', 15)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pivote_horarios_carreras_estudiantes');
    }
};
