<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('estudiantes', function (Blueprint $table) {
            $table->id();
            $table->string('observacion')->nullable();
            $table->longText('fotografia')->nullable();
            $table->string('estado_estudiante', 10)->nullable(); // ingreso - estudiante
            $table->foreignId('id_persona')->constrained('personas');
            $table->foreignId('id_colegio')->constrained('colegios');
            $table->foreignId('id_apoderado')->constrained('apoderados')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('estudiantes');
    }
};
