<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('docentes', function (Blueprint $table) {
            $table->id();
            $table->string('observacion')->nullable();
            $table->longText('fotografia')->nullable();
            $table->foreignId('id_persona')->constrained('personas');
            $table->string('estado', 10)->nullable(); // contratado o ya no
            $table->longText('descripcion')->nullable(); // cual es su especualidad
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('docentes');
    }
};
