<?php namespace App\Services;
use App\Models\Persona\Persona;
use Illuminate\Database\Eloquent\Builder;

class SearchPersona
{
    public function buscarPersonas(string $search): Builder
    {
        return Persona::where(function ($query) use ($search) {
            $query
                ->where('dni', 'like', "%$search%")
                ->orWhere('nombres', 'like', "%$search%")
                ->orWhere('apellido_paterno', 'like', "%$search%")
                ->orWhere('apellido_materno', 'like', "%$search%")
                ->orWhere('celular', 'like', "%$search%")
                ->orWhere('domicilio', 'like', "%$search%");
        });
    }
}
