<?php

namespace App\Services;

use App\Models\PivoteHorario;
use Illuminate\Database\Eloquent\Builder;

class SearchHorarioCiclo
{
    protected $searchHorario;
    protected $searchCiclo;

    public function __construct(SearchHorario $searchHorario, SearchCiclo $searchCiclo)
    {
        $this->searchHorario = $searchHorario;
        $this->searchCiclo = $searchCiclo;
    }

    public function buscarHorarioCiclo(?string $search, ?array $estados, ?string $hora): Builder
    {

        if ($hora) {
            $horarioIds = $this->searchHorario->buscarHorarios(null, $hora)->pluck('id');

            if ($horarioIds->isEmpty()) {
                return PivoteHorario::query()->whereRaw('0=1');
            }
            return PivoteHorario::query()
                ->whereIn('id_horario', $horarioIds)
                ->with('horario', 'ciclo');
        }

        $horarioIds = $this->searchHorario->buscarHorarios($search, null)->pluck('id');
        $cicloIds = $this->searchCiclo->buscarCiclos($search ?? '')->pluck('id');

        if (!empty($estados)) {
            $cicloIds = $this->searchCiclo->buscarPorEstados($estados)->pluck('id');
        }

        return PivoteHorario::query()
            ->when($horarioIds->isNotEmpty(), function ($query) use ($horarioIds) {
                $query->whereIn('id_horario', $horarioIds);
            })
            ->when($cicloIds->isNotEmpty(), function ($query) use ($cicloIds) {
                $query->orWhereIn('id_ciclo', $cicloIds);
            })
            ->with('horario', 'ciclo');
    }
}
