<?php

namespace App\Services;

use App\Models\Persona\Docente;
use Illuminate\Database\Eloquent\Builder;

class SearchDocente
{
    protected $searchPersona;

    public function __construct(SearchPersona $searchPersona)
    {
        $this->searchPersona = $searchPersona;
    }

    public function buscarDocentes(string $search): Builder
    {
        $personaQuery = $this->searchPersona->buscarPersonas($search);
        return Docente::query()
            ->where('observacion', 'like', "%$search%")
            ->orWhere('estado', 'like', "%$search%")
            ->orWhere(function ($query) use ($personaQuery) {
                $query->whereIn('id_persona', $personaQuery->pluck('id'));
            });
    }
}
