<?php

namespace App\Services;

use App\Models\Academico\Ciclo;
use Illuminate\Database\Eloquent\Builder;

class SearchCiclo
{
    public function buscarCiclos(string $search): Builder
    {
        return Ciclo::where('nombre', 'like', "%$search%")
            ->orWhere('estado', 'like', "%$search%");
    }

    public function buscarPorEstados(array $estados): Builder
    {
        return Ciclo::whereIn('estado', $estados);
    }
}
