<?php

namespace App\Services;

use App\Models\Educacion\Carrera;
use Illuminate\Database\Eloquent\Builder;

class SearchCarrera
{
    protected $searchArea;

    public function __construct(SearchArea $searchArea)
    {
        $this->searchArea = $searchArea;
    }

    public function buscarCarreras(string $search): Builder
    {
        $areaQuery = $this->searchArea->buscarAreas($search);

        return Carrera::query()
            ->where('nombre', 'like', "%$search%")
            ->orWhere(function ($query) use ($areaQuery) {
                $query->whereIn('id_area', $areaQuery->pluck('id'));
            });
    }
}
