<?php

namespace App\Services;

use App\Models\PivoteAreaCursoDocente;
use Illuminate\Database\Eloquent\Builder;

class SearchAreaCursoDocente
{
    protected $searchCurso;
    protected $searchArea;
    protected $searchPersona;

    public function __construct(SearchCurso $searchCurso, SearchArea $searchArea, SearchPersona $searchPersona)
    {
        $this->searchCurso = $searchCurso;
        $this->searchArea = $searchArea;
        $this->searchPersona = $searchPersona;
    }

    public function buscarAreaCursoDocente(string $search): Builder
    {
        $cursoQuery = $this->searchCurso->buscarCursos($search);
        $areaQuery = $this->searchArea->buscarAreas($search);
        $personaQuery = $this->searchPersona->buscarPersonas($search);

        return PivoteAreaCursoDocente::query()
            ->where(function ($query) use ($cursoQuery, $areaQuery, $personaQuery) {
                $query
                    ->whereIn('id_curso', $cursoQuery->pluck('id'))
                    ->orWhereIn('id_area', $areaQuery->pluck('id'))
                    ->orWhereHas('docente.persona', function ($personaQueryBuilder) use ($personaQuery) {
                        $personaQueryBuilder->whereIn('id', $personaQuery->pluck('id'));
                    });
            })
            ->with(['docente.persona']);
    }
}
