<?php

namespace App\Services;

use App\Models\Educacion\Area;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

class ConsultaIngresantes
{
    public function fetchFacultades()
    {
        $client = new Client();
        try {
            $response = $client->request('GET', 'https://academia.cingenieria.edu.pe/webService/academia/ingresantes_academia/lista_facultades', [
                'headers' => [
                    'Accept' => 'application/json',
                ],
                'verify' => false,
            ]);

            $data = json_decode($response->getBody(), true);

            if ($data) {
                return response()->json($data, 200);
            }

            return response()->json(['message' => 'No se encontraron facultades.'], 404);
        } catch (RequestException $e) {
            $error = $e->getResponse() ? $e->getResponse()->getBody()->getContents() : $e->getMessage();
            return response()->json(['message' => 'Error en la conexión a la API.', 'error' => $error], 500);
        }
    }

    public function fetchIngresantes(string $search)
    {
        return Area::where('nombre', 'like', "%$search%");
    }
}
