<?php

namespace App\Models;

use App\Models\Evaluacion\Pregunta;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PivotePreguntaDocente extends Model
{
    use HasFactory;

    protected $table = 'pivote_preguntas_docentes';
    protected $fillable = ['id_pregunta', 'id_pivote_area_curso_docente'];

    public function pregunta()
    {
        return $this->belongsTo(Pregunta::class, 'id_pregunta');
    }
    public function pivote_area_curso_docente()
    {
        return $this->belongsTo(PivoteAreaCursoDocente::class, 'id_pivote_area_curso_docente');
    }

    public function pivote_encuestas_docentes()
    {
        return $this->hasMany(PivoteEncuestaDocente::class, 'id_pivote_pregunta_docente');
    }
}
