<?php

namespace App\Models;

use App\Models\Educacion\Carrera;
use App\Models\Educacion\Universidad;
use App\Models\Evaluacion\Asistencia;
use App\Models\Evaluacion\Conducta;
use App\Models\Evaluacion\Nota;
use App\Models\Finanza\Beca;
use App\Models\Finanza\Pago;
use App\Models\Persona\Estudiante;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PivoteHorarioCarreraEstudiante extends Model
{
    use HasFactory;

    protected $table = 'pivote_horarios_carreras_estudiantes';
    protected $fillable = ['id_pivote_horario', 'id_carrera', 'id_universidad', 'estado_pago', 'estado_mensaje', 'id_estudiante'];

    public function carrera()
    {
        return $this->belongsTo(Carrera::class, 'id_carrera');
    }
    public function universidad()
    {
        return $this->belongsTo(Universidad::class, 'id_universidad');
    }
    public function pivote_horario()
    {
        return $this->belongsTo(PivoteHorario::class, 'id_pivote_horario');
    }
    public function estudiante()
    {
        return $this->belongsTo(Estudiante::class, 'id_estudiante');
    }

    public function asistencias()
    {
        return $this->hasMany(Asistencia::class, 'id_pivote_horario_carrera_estudiante');
    }
    public function conductas()
    {
        return $this->hasMany(Conducta::class, 'id_pivote_horario_carrera_estudiante');
    }
    public function notas()
    {
        return $this->hasMany(Nota::class, 'id_pivote_horario_carrera_estudiante');
    }
    public function pagos()
    {
        return $this->hasMany(Pago::class, 'id_pivote_horario_carrera_estudiante');
    }
    public function becas()
    {
        return $this->hasMany(Beca::class, 'id_pivote_horario_carrera_estudiante');
    }
    public function pivote_encuesta_estudiante()
    {
        return $this->hasMany(PivoteEncuestaEstudiante::class, 'id_pivote_horario_carrera_estudiante');
    }
}
