<?php

namespace App\Models;

use App\Models\Academico\Ciclo;
use App\Models\Academico\Horario;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PivoteHorario extends Model
{
    use HasFactory;

    protected $table = 'pivote_horarios';
    protected $fillable = ['id_horario', 'id_ciclo'];

    public function ciclo()
    {
        return $this->belongsTo(Ciclo::class, 'id_ciclo');
    }
    public function horario()
    {
        return $this->belongsTo(Horario::class, 'id_horario');
    }

    public function pivote_horarios_carreras_estudiantes()
    {
        return $this->hasMany(PivoteHorarioCarreraEstudiante::class, 'id_pivote_horario');
    }
}
