<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PivoteEncuestaEstudiante extends Model
{
    use HasFactory;

    protected $table = 'pivote_encuestas_estudiantes';
    protected $fillable = ['respuesta', 'id_pivote_encuesta_docente', 'id_pivote_horario_carrera_estudiante'];
    
    public function pivote_encuesta_docente()
    {
        return $this->belongsTo(PivoteEncuestaDocente::class, 'id_pivote_encuesta_docente');
    }
    public function pivote_horario_carrera_estudiante()
    {
        return $this->belongsTo(PivoteHorarioCarreraEstudiante::class, 'id_pivote_horario_carrera_estudiante');
    }

}

