<?php

namespace App\Models;

use App\Models\Evaluacion\Encuesta;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PivoteEncuestaDocente extends Model
{
    use HasFactory;

    protected $table = 'pivote_encuestas_docentes';
    protected $fillable = ['id_encuesta', 'id_pivote_pregunta_docente'];

    public function encuesta()
    {
        return $this->belongsTo(Encuesta::class, 'id_encuesta');
    }
    public function pivote_pregunta_docente()
    {
        return $this->belongsTo(PivotePreguntaDocente::class, 'id_pivote_pregunta_docente');
    }
 
    public function pivote_encuestas_estudiantes()
    {
        return $this->hasMany(PivoteEncuestaEstudiante::class, 'id_pivote_encuesta_docente');
    }
    
}
