<?php

namespace App\Models;

use App\Models\Academico\Curso;
use App\Models\Educacion\Area;
use App\Models\Persona\Docente;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PivoteAreaCursoDocente extends Model
{
    use HasFactory;

    protected $table = 'pivote_areas_cursos_docentes';
    protected $fillable = ['id_area', 'id_curso', 'id_docente'];

    public function area()
    {
        return $this->belongsTo(Area::class, 'id_area');
    }
    public function curso()
    {
        return $this->belongsTo(Curso::class, 'id_curso');
    }
    public function docente()
    {
        return $this->belongsTo(Docente::class, 'id_docente');
    }

    public function pivote_preguntas_docentes()
    {
        return $this->hasMany(PivotePreguntaDocente::class, 'id_pivote_area_curso_docente');
    }
}
