<?php

namespace App\Models\Persona;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Persona extends Model
{
    use HasFactory;

    protected $fillable = ['dni', 'nombres', 'apellido_paterno', 'apellido_materno', 'celular', 'domicilio'];

    public function docente()
    {
        return $this->hasOne(Docente::class, 'id_persona');
    }

    public function apoderado()
    {
        return $this->hasOne(Apoderado::class, 'id_persona');
    }

    public function estudiante()
    {
        return $this->hasOne(Estudiante::class, 'id_persona');
    }
}
