<?php

namespace App\Models\Persona;

use App\Models\Educacion\Colegio;
use App\Models\PivoteHorarioCarreraEstudiante;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Estudiante extends Model
{
    use HasFactory;

    protected $fillable = ['observacion', 'fotografia', 'estado_estudiante',  'id_persona', 'id_colegio', 'id_apoderado'];

    public function persona()
    {
        return $this->belongsTo(Persona::class, 'id_persona');
    }

    public function colegio()
    {
        return $this->belongsTo(Colegio::class, 'id_colegio');
    }

    public function apoderado()
    {
        return $this->belongsTo(Apoderado::class, 'id_apoderado');
    }

    public function pivote_horarios_carreras_estudiantes()
    {
        return $this->hasMany(PivoteHorarioCarreraEstudiante::class, 'id_estudiante');
    }
}
