<?php

namespace App\Models\Persona;

use App\Models\PivoteAreaCursoDocente;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Docente extends Model
{
    use HasFactory;

    protected $fillable = ['observacion', 'fotografia', 'id_persona', 'estado', 'descripcion'];

    public function persona()
    {
        return $this->belongsTo(Persona::class, 'id_persona');
    }

    public function pivote_areas_cursos_docentes()
    {
        return $this->hasMany(PivoteAreaCursoDocente::class, 'id_docente');
    }

}
