<?php

namespace App\Models\Evaluacion;

use App\Models\PivoteEncuestaDocente;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Encuesta extends Model
{
    use HasFactory;
    protected $table = 'encuestas';
    protected $fillable = ['nombre', 'fecha_inicio', 'fecha_final', 'estado'];

    public function pivote_encuestas_docentes()
    {
        return $this->hasMany(PivoteEncuestaDocente::class, 'id_encuesta');
    }
}
