<?php

namespace App\Models\Educacion;

use App\Models\PivoteHorarioCarreraEstudiante;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Carrera extends Model
{
    use HasFactory;

    protected $fillable = ['nombre', 'id_area'];

    public function area()
    {
        return $this->belongsTo(Area::class, 'id_area');
    }

    public function pivote_horarios_carreras_estudiantes()
    {
        return $this->hasMany(PivoteHorarioCarreraEstudiante::class, 'id_carrera');
    }
}
